#version 330

uniform sampler2D color0Tex;
uniform sampler2D shadowMap0;
uniform sampler2D shadowMap1;
uniform sampler2D shadowMap2;
uniform sampler2D shadowMap3;
uniform mat4 shadowViewProj[4];
uniform mat4 invPersp;
uniform mat4 invView;
uniform vec4 viewSpaceLight0;
uniform vec4 vpSize;
uniform float farClip;

in vec4 uv;

out vec4 oColor;

const float Rand[64] =  float[](
	0.5812435625, 0.1755130939, 0.5773812415, 0.6302625489, 0.9157151699, 0.6239344890, 0.0823797197, 0.3656869840,
	0.6209343808, 0.4557871314, 0.4128129541, 0.1954525812, 0.1495418730, 0.9772899382, 0.9218936764, 0.3550820233,
	0.4289238558, 0.3415204384, 0.1350318573, 0.3735138010, 0.9814555209, 0.7868003421, 0.5017340025, 0.7624520194,
	0.4700040189, 0.2337477379, 0.9263954918, 0.4123050599, 0.0384631960, 0.4496070423, 0.9166926634, 0.7958192893,
	0.2987334961, 0.6878718520, 0.9199990897, 0.5948356397, 0.2455536279, 0.5445638793, 0.7095571767, 0.8421780159,
	0.3623420723, 0.5029978406, 0.1651945257, 0.7180143521, 0.9563527190, 0.0239255282, 0.7702463894, 0.3938634013,
	0.0902333989, 0.7381059086, 0.3863340875, 0.1188350744, 0.7461711495, 0.4534665570, 0.9295868438, 0.8102192289,
	0.0335657100, 0.5737184475, 0.3370439849, 0.1583394389, 0.4385470276, 0.0599520180, 0.8724608424, 0.8187828420
);
	
vec4 screenToProj(vec2 iCoord)
{
    return vec4(2.0f * vec2(iCoord.x, 1.0f - iCoord.y) - 1, 0.0, 1.0);
}

vec3 depthToPosition(float iDepth, vec4 iPosProj)
{
    vec3 vPosView = (invPersp * iPosProj).xyz;
    vec3 vViewRay = vec3(vPosView.xy * (farClip / vPosView.z), farClip);
    vec3 vPosition = vViewRay * iDepth;
    return vPosition;
}

void main()
{
	float depth = textureLod(color0Tex, uv.xy, 0).z;
	
	if(depth == 0) {
		depth = -1.0;
	}
	
	vec4 projSpace = screenToProj(uv.xy);
	
	float rand = Rand[int(mod(vpSize.x*uv.x, 8) + mod(vpSize.y*uv.y, 8)*8)];
	
	vec3 camVs = depthToPosition(-1.0, projSpace);
	float intensity = pow(max(dot(-viewSpaceLight0.xyz, normalize(camVs)), 0.0), 1.5) + 0.2;
	
	vec4 posVs;
	vec4 posWs;
	vec4 shadowUV0, shadowUV1, shadowUV2, shadowUV3;
	
	float light = 0.0;
	
	const float MaxDepth = 48.0;
	const int Samples = 64;
	const float Incr = 1.0 / float(Samples);
	
	float range = max(depth, -MaxDepth / farClip);
	
	float d = -1.0/farClip;
	float l;
	int i;
	for(i = 0; i < Samples; ++i) {
		d = (i + rand)*Incr*range;
		posVs = vec4(depthToPosition(d, projSpace), 1.0);
		posWs = invView * posVs;
		
		shadowUV0 = shadowViewProj[0] * posWs;
		shadowUV0.z = shadowUV0.z * 0.5 + 0.5;
		shadowUV1 = shadowViewProj[1] * posWs;
		shadowUV1.z = shadowUV1.z * 0.5 + 0.5;
		shadowUV2 = shadowViewProj[2] * posWs;
		shadowUV2.z = shadowUV2.z * 0.5 + 0.5;
		shadowUV3 = shadowViewProj[3] * posWs;
		shadowUV3.z = shadowUV3.z * 0.5 + 0.5;
		
		if(all(greaterThan(shadowUV0.xy, vec2(0,0))) && all(lessThan(shadowUV0.xy, vec2(1,1)))) {
			l = textureLod(shadowMap0, shadowUV0.xy, 0).x  >= shadowUV0.z ? 1.0 : 0.0;
		} else if(all(greaterThan(shadowUV1.xy, vec2(0,0))) && all(lessThan(shadowUV1.xy, vec2(1,1)))) {
			l = textureLod(shadowMap1, shadowUV1.xy, 0).x >= shadowUV1.z ? 1.0 : 0.0;
		} else if(all(greaterThan(shadowUV2.xy, vec2(0,0))) && all(lessThan(shadowUV2.xy, vec2(1,1)))) {
			l = textureLod(shadowMap2, shadowUV2.xy, 0).x >= shadowUV2.z ? 1.0 : 0.0;
		} else {
			l = textureLod(shadowMap3, shadowUV3.xy, 0).x >= shadowUV3.z ? 1.0 : 0.0;
		}
		
		light += (l * intensity) / float(Samples);
	}
	
	oColor = vec4(vec3(0.425, 0.275, 0.135)*light * 0.6, 0.0);
}
